class Helpers {
    static dotNetHelper;

    static setDotNetHelper(value) {
      Helpers.dotNetHelper = value;
    }

    static async onMouseDown(row,column) {
      await Helpers.dotNetHelper.invokeMethodAsync('OnMouseDown', row, column);
    }
    static async onMouseUp(row,column) {
      await Helpers.dotNetHelper.invokeMethodAsync('OnMouseUp', row, column);
    }
}

window.Helpers = Helpers;

function AddEventListener() {
    const tbody = document.querySelector('#sheetgrid tbody');
    tbody.addEventListener('mousedown', function (e) {
        const cell = e.target.closest('td');
        if (!cell) { return; } // Quit, not clicked on a cell
        const row = cell.parentElement;
        if (!row) return;
        Helpers.onMouseDown(row.rowIndex, cell.cellIndex);
    });
    tbody.addEventListener('mouseup', function (e) {
        const cell = e.target.closest('td');
        if (!cell) { return; } // Quit, not clicked on a cell
        const row = cell.parentElement;
        if (!row) return;
        Helpers.onMouseUp(row.rowIndex, cell.cellIndex);
    });
    return null;
}

function SelectCells(cells) {
    for (i = 0; i < cells.length; i++) {
        const cell = document.getElementById(cells[i]);
        if (!cell) return;
        cell.classList.add('aes');
    }
}
function DeSelectCells(cells) {
    for (i = 0; i < cells.length; i++) {
        const cell = document.getElementById(cells[i]);
        if (!cell) return;
        cell.classList.remove('aes');
    }
}